import pandas as pd  
import pickle 
from decision_company import read_csv_file, fetch_column, logical_or, filter_by_condition, count_rows

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Create conditions  
condition1 = fetch_column(stable_employment, 'housing') == 'rent'  
condition2 = fetch_column(stable_employment, 'housing') == 'own'  
  
# Perform logical OR operation  
final_condition = logical_or(condition1, condition2)  
  
# Filter the clients residing in rented or owned housing  
rented_owned_housing = filter_by_condition(stable_employment, final_condition)  
  
# Calculate the count of clients residing in rented or owned housing  
result_count = count_rows(rented_owned_housing)  
  
print(result_count)  
pickle.dump(result_count,open("./ref_result/result_count_2.pkl","wb"))